#include "userprocess.h"
#include <stdio.h>
#include "message.h"

User_Process::User_Process(int in_number_processes)
{
	number_processes = in_number_processes;
}

// ----------------------------------------------------------------------------

void User_Process::Set_Start_State()
{
	u = process_id;
	send = process_id;
	status = unknown;
}

// ----------------------------------------------------------------------------

void User_Process::Generate_Messages()
{
	Message outgoing_message;
	outgoing_message.uid = send;

	int destination_process_id = process_id % number_processes + 1;

	printf("Process %d: Sending data (send=%d) to process %d\n", process_id, send,
		destination_process_id);

	// Convert Message to SN_Message
	SN_Message* sn_message_ptr = reinterpret_cast<SN_Message *> (&outgoing_message);

	// Remember process ids are 1 based!
	Send(sn_message_ptr, destination_process_id);
}

// ----------------------------------------------------------------------------

void User_Process::Transition(map<SN_Message *,int> sn_msgs)
{
	// ------------------------------------
	// Convert SN_Messages to Messages
	map<Message *,int> inbound_msgs;
	map<SN_Message *,int>::iterator an_sn_msg;
	
	for(an_sn_msg = sn_msgs.begin();
		an_sn_msg != sn_msgs.end(); an_sn_msg++)
	{
		Message *a_msg = reinterpret_cast<Message *>(an_sn_msg->first);
		inbound_msgs.insert(make_pair(a_msg,an_sn_msg->second));
	}
	// ------------------------------------

	// This algorithm expects only 1 message.
	Message *inbound_msg;
	inbound_msg = inbound_msgs.begin()->first;

	int v = inbound_msg->uid;

	printf("Process %d: Received data (v=%d)\n", u, v);

	if (v > u)
		send = v;
	else if (v == u)
	{
		status = leader;
		printf("-->PROCESS %d DECLARED ITSELF THE LEADER...<--\n",u);
	}
	else // (v < u): do nothing
		;
}
